/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_11 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 3140, "epsg", 3140,
        "Viti Levu 1912 / Viti Levu Grid");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=-18 +lon_0=178 +x_0=109435.392 +y_0=14");
    add_proj4text (p, 1,
        "1622.272 +a=6378306.3696 +b=6356571.996 +towgs84=51,391,");
    add_proj4text (p, 2,
        "-36,0,0,0,0 +to_meter=0.201168 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Viti Levu 1912 / Viti Levu Grid\",GEOGCS[\"Viti");
    add_srs_wkt (p, 1,
        " Levu 1912\",DATUM[\"Viti_Levu_1912\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (international foot)\",6378306.3696,293.46630765563");
    add_srs_wkt (p, 3,
        "61,AUTHORITY[\"EPSG\",\"7055\"]],TOWGS84[51,391,-36,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6752\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4752\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",-18],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 9,
        "n\",178],PARAMETER[\"false_easting\",544000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",704000],UNIT[\"link\",0.201168,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9098\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"3140\"]]");
    p = add_epsg_def (filter, first, last, 3141, "epsg", 3141,
        "Fiji 1956 / UTM zone 60S");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +south +ellps=intl +towgs84=265.025,3");
    add_proj4text (p, 1,
        "84.929,-194.046,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fiji 1956 / UTM zone 60S\",GEOGCS[\"Fiji 1956\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Fiji_1956\",SPHEROID[\"International 1924\",637");
    add_srs_wkt (p, 2,
        "8388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[265.025,3");
    add_srs_wkt (p, 3,
        "84.929,-194.046,0,0,0,0],AUTHORITY[\"EPSG\",\"6721\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4721\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",177],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3141\"]]");
    p = add_epsg_def (filter, first, last, 3142, "epsg", 3142,
        "Fiji 1956 / UTM zone 1S");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +south +ellps=intl +towgs84=265.025,38");
    add_proj4text (p, 1,
        "4.929,-194.046,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fiji 1956 / UTM zone 1S\",GEOGCS[\"Fiji 1956\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Fiji_1956\",SPHEROID[\"International 1924\",6378");
    add_srs_wkt (p, 2,
        "388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[265.025,38");
    add_srs_wkt (p, 3,
        "4.929,-194.046,0,0,0,0],AUTHORITY[\"EPSG\",\"6721\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4721\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-177],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3142\"]]");
    p = add_epsg_def (filter, first, last, 3143, "epsg", 3143,
        "Fiji 1986 / Fiji Map Grid (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-17 +lon_0=178.75 +k=0.99985 +x_0=200");
    add_proj4text (p, 1,
        "0000 +y_0=4000000 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 2,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Fiji 1986 / Fiji Map Grid (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Fiji 1986\",DATUM[\"Fiji_Geodetic_Datum_1986\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"WGS 72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6720\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4720\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",-17],PARAMETER[\"central_meridian\",178.75],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.99985],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "2000000],PARAMETER[\"false_northing\",4000000],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3143\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 3146, "epsg", 3146,
        "Pulkovo 1942 / 3-degree Gauss-Kruger zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger zone 6\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "8],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",6500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3146\"]]");
    p = add_epsg_def (filter, first, last, 3147, "epsg", 3147,
        "Pulkovo 1942 / 3-degree Gauss-Kruger CM 18E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / 3-degree Gauss-Kruger CM 18E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "8],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3147\"]]");
    p = add_epsg_def (filter, first, last, 3148, "epsg", 3148,
        "Indian 1960 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.413140239 +");
    add_proj4text (p, 1,
        "towgs84=198,881,317,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1960 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "60\",DATUM[\"Indian_1960\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[198,881,317,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6131\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4131\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3148\"]]");
    p = add_epsg_def (filter, first, last, 3149, "epsg", 3149,
        "Indian 1960 / UTM zone 49N");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +a=6377276.345 +b=6356075.413140239 +");
    add_proj4text (p, 1,
        "towgs84=198,881,317,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1960 / UTM zone 49N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "60\",DATUM[\"Indian_1960\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[198,881,317,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6131\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4131\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",111],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3149\"]]");
    p = add_epsg_def (filter, first, last, 3150, "epsg", 3150,
        "Pulkovo 1995 / 3-degree Gauss-Kruger zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger zone 6\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",18");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",6500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3150\"]]");
    p = add_epsg_def (filter, first, last, 3151, "epsg", 3151,
        "Pulkovo 1995 / 3-degree Gauss-Kruger CM 18E");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / 3-degree Gauss-Kruger CM 18E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[24.47,-130.89,-81.56,-0,-0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "00\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",18");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXI");
    add_srs_wkt (p, 12,
        "S[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3151\"]]");
    p = add_epsg_def (filter, first, last, 3152, "epsg", 3152,
        "ST74");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.05779 +k=0.99999425 +x_0=");
    add_proj4text (p, 1,
        "100178.1808 +y_0=-6500614.7836 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ST74\",GEOGCS[\"SWEREF99\",DATUM[\"SWEREF99\",S");
    add_srs_wkt (p, 1,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 2,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4619\"]],PROJEC");
    add_srs_wkt (p, 6,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 7,
        "igin\",0],PARAMETER[\"central_meridian\",18.05779],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.99999425],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",100178.1808],PARAMETER[\"false_northing\",-6500614");
    add_srs_wkt (p, 10,
        ".7836],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"31");
    add_srs_wkt (p, 12,
        "52\"]]");
    p = add_epsg_def (filter, first, last, 3153, "epsg", 3153,
        "NAD83(CSRS) / BC Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=50 +lat_2=58.5 +lat_0=45 +lon_0=-126 +x");
    add_proj4text (p, 1,
        "_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / BC Albers\",GEOGCS[\"NAD83(CSRS)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Albers_Conic_Equal_Area\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_1\",50],PARAMETER[\"standard_parallel_2\",58.5],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_center\",45],PARAMETER[\"longitude_of");
    add_srs_wkt (p, 10,
        "_center\",-126],PARAMETER[\"false_easting\",1000000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3153\"]]");
    p = add_epsg_def (filter, first, last, 3154, "epsg", 3154,
        "NAD83(CSRS) / UTM zone 7N");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 7N\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-141],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3154\"]]");
    p = add_epsg_def (filter, first, last, 3155, "epsg", 3155,
        "NAD83(CSRS) / UTM zone 8N");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 8N\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-135],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3155\"]]");
    p = add_epsg_def (filter, first, last, 3156, "epsg", 3156,
        "NAD83(CSRS) / UTM zone 9N");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 9N\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",-129],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3156\"]]");
    p = add_epsg_def (filter, first, last, 3157, "epsg", 3157,
        "NAD83(CSRS) / UTM zone 10N");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 10N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",-123],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3157\"]]");
    p = add_epsg_def (filter, first, last, 3158, "epsg", 3158,
        "NAD83(CSRS) / UTM zone 14N");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 14N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",-99],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3158\"]]");
    p = add_epsg_def (filter, first, last, 3159, "epsg", 3159,
        "NAD83(CSRS) / UTM zone 15N");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 15N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",-93],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3159\"]]");
    p = add_epsg_def (filter, first, last, 3160, "epsg", 3160,
        "NAD83(CSRS) / UTM zone 16N");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 16N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",0],PARAMETER[\"central_meridian\",-87],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3160\"]]");
    p = add_epsg_def (filter, first, last, 3161, "epsg", 3161,
        "NAD83 / Ontario MNR Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x");
    add_proj4text (p, 1,
        "_0=930000 +y_0=6430000 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Ontario MNR Lambert\",GEOGCS[\"NAD83\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 7,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",44.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"standard_parallel_2\",53.5],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",-85");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",930000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",6430000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"3161\"]]");
    p = add_epsg_def (filter, first, last, 3162, "epsg", 3162,
        "NAD83(CSRS) / Ontario MNR Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x");
    add_proj4text (p, 1,
        "_0=930000 +y_0=6430000 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Ontario MNR Lambert\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4617\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",44.5],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 9,
        "l_2\",53.5],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"central_meridian\",-85],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "930000],PARAMETER[\"false_northing\",6430000],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3162\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 3163, "epsg", 3163,
        "RGNC91-93 / Lambert New Caledonia");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGNC91-93 / Lambert New Caledonia\",GEOGCS[\"RG");
    add_srs_wkt (p, 1,
        "NC91-93\",DATUM[\"Reseau_Geodesique_de_Nouvelle_Caledoni");
    add_srs_wkt (p, 2,
        "e_91_93\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6749\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4749");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_1\",-20.66666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",-22.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",-21.5],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 11,
        "\",166],PARAMETER[\"false_easting\",400000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",300000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"3163\"]]");
    p = add_epsg_def (filter, first, last, 3164, "epsg", 3164,
        "ST87 Ouvea / UTM zone 58S");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=WGS84 +towgs84=-56.263,");
    add_proj4text (p, 1,
        "16.136,-22.856,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ST87 Ouvea / UTM zone 58S\",GEOGCS[\"ST87 Ouvea");
    add_srs_wkt (p, 1,
        "\",DATUM[\"ST87_Ouvea\",SPHEROID[\"WGS 84\",6378137,298.");
    add_srs_wkt (p, 2,
        "257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[-56.263,");
    add_srs_wkt (p, 3,
        "16.136,-22.856,0,0,0,0],AUTHORITY[\"EPSG\",\"6750\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4750\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",165],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3164\"]]");
    p = add_epsg_def (filter, first, last, 3165, "epsg", 3165,
        "NEA74 Noumea / Noumea Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-22.24469175 +lat_2=-22.29469175 +lat_0");
    add_proj4text (p, 1,
        "=-22.26969175 +lon_0=166.44242575 +x_0=0.66 +y_0=1.02 +e");
    add_proj4text (p, 2,
        "llps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +units=");
    add_proj4text (p, 3,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NEA74 Noumea / Noumea Lambert\",GEOGCS[\"NEA74 ");
    add_srs_wkt (p, 1,
        "Noumea\",DATUM[\"NEA74_Noumea\",SPHEROID[\"International");
    add_srs_wkt (p, 2,
        " 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-10.18,-350.43,291.37,0,0,0,0],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 4,
        "44\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4644\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",-22.24469175],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 9,
        "-22.29469175],PARAMETER[\"latitude_of_origin\",-22.26969");
    add_srs_wkt (p, 10,
        "175],PARAMETER[\"central_meridian\",166.44242575],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",0.66],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",1.02],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"31");
    add_srs_wkt (p, 14,
        "65\"]]");
    p = add_epsg_def (filter, first, last, 3166, "epsg", 3166,
        "NEA74 Noumea / Noumea Lambert 2");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-22.24472222222222 +lat_2=-22.294722222");
    add_proj4text (p, 1,
        "22222 +lat_0=-22.26972222222222 +lon_0=166.4425 +x_0=8.3");
    add_proj4text (p, 2,
        "13000000000001 +y_0=-2.354 +ellps=intl +towgs84=-10.18,-");
    add_proj4text (p, 3,
        "350.43,291.37,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NEA74 Noumea / Noumea Lambert 2\",GEOGCS[\"NEA7");
    add_srs_wkt (p, 1,
        "4 Noumea\",DATUM[\"NEA74_Noumea\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-10.18,-350.43,291.37,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6644\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4644\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 8,
        "rallel_1\",-22.24472222222222],PARAMETER[\"standard_para");
    add_srs_wkt (p, 9,
        "llel_2\",-22.29472222222222],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 10,
        "gin\",-22.26972222222222],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",166.4425],PARAMETER[\"false_easting\",8.313],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",-2.354],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"3166\"]]");
    p = add_epsg_def (filter, first, last, 3167, "epsg", 3167,
        "Kertau (RSO) / RSO Malaya (ch)");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=");
    add_proj4text (p, 1,
        "0.99984 +x_0=40000 +y_0=0 +gamma=323.1301023611111 +a=63");
    add_proj4text (p, 2,
        "77295.664 +b=6356094.667915204 +to_meter=20.116756 +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau (RSO) / RSO Malaya (ch)\",GEOGCS[\"Kerta");
    add_srs_wkt (p, 1,
        "u (RSO)\",DATUM[\"Kertau_RSO\",SPHEROID[\"Everest 1830 (");
    add_srs_wkt (p, 2,
        "RSO 1969)\",6377295.664,300.8017,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "56\"]],AUTHORITY[\"EPSG\",\"6751\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4751\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_center\",4],PARAMETER[\"longitud");
    add_srs_wkt (p, 8,
        "e_of_center\",102.25],PARAMETER[\"azimuth\",323.0257905]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"rectified_grid_angle\",323.1301023611111],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",1988.392164223695],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        "],UNIT[\"British chain (Sears 1922 truncated)\",20.11675");
    add_srs_wkt (p, 13,
        "6,AUTHORITY[\"EPSG\",\"9301\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 14,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3167\"]]");
    p = add_epsg_def (filter, first, last, 3168, "epsg", 3168,
        "Kertau (RSO) / RSO Malaya (m)");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=");
    add_proj4text (p, 1,
        "0.99984 +x_0=804670.24 +y_0=0 +gamma=323.1301023611111 +");
    add_proj4text (p, 2,
        "a=6377295.664 +b=6356094.667915204 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau (RSO) / RSO Malaya (m)\",GEOGCS[\"Kertau");
    add_srs_wkt (p, 1,
        " (RSO)\",DATUM[\"Kertau_RSO\",SPHEROID[\"Everest 1830 (R");
    add_srs_wkt (p, 2,
        "SO 1969)\",6377295.664,300.8017,AUTHORITY[\"EPSG\",\"705");
    add_srs_wkt (p, 3,
        "6\"]],AUTHORITY[\"EPSG\",\"6751\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4751\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_center\",4],PARAMETER[\"longitud");
    add_srs_wkt (p, 8,
        "e_of_center\",102.25],PARAMETER[\"azimuth\",323.0257905]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"rectified_grid_angle\",323.1301023611111],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",804670.24],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"316");
    add_srs_wkt (p, 14,
        "8\"]]");
    p = add_epsg_def (filter, first, last, 3169, "epsg", 3169,
        "RGNC91-93 / UTM zone 57S");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGNC91-93 / UTM zone 57S\",GEOGCS[\"RGNC91-93\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Reseau_Geodesique_de_Nouvelle_Caledonie_91_93\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6749\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4749\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",159],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3169\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 3170, "epsg", 3170,
        "RGNC91-93 / UTM zone 58S");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGNC91-93 / UTM zone 58S\",GEOGCS[\"RGNC91-93\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Reseau_Geodesique_de_Nouvelle_Caledonie_91_93\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6749\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4749\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",165],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3170\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 3171, "epsg", 3171,
        "RGNC91-93 / UTM zone 59S");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RGNC91-93 / UTM zone 59S\",GEOGCS[\"RGNC91-93\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Reseau_Geodesique_de_Nouvelle_Caledonie_91_93\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6749\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4749\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",171],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",10000000],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3171\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 3172, "epsg", 3172,
        "IGN53 Mare / UTM zone 59S");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=intl +towgs84=287.58,17");
    add_proj4text (p, 1,
        "7.78,-135.41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"IGN53 Mare / UTM zone 59S\",GEOGCS[\"IGN53 Mare");
    add_srs_wkt (p, 1,
        "\",DATUM[\"IGN53_Mare\",SPHEROID[\"International 1924\",");
    add_srs_wkt (p, 2,
        "6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[287.58");
    add_srs_wkt (p, 3,
        ",177.78,-135.41,0,0,0,0],AUTHORITY[\"EPSG\",\"6641\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"4641\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",171],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3172\"]]");
    p = add_epsg_def (filter, first, last, 3174, "epsg", 3174,
        "NAD83 / Great Lakes Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568");
    add_proj4text (p, 1,
        "977 +lon_0=-84.455955 +x_0=1000000 +y_0=1000000 +datum=N");
    add_proj4text (p, 2,
        "AD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Great Lakes Albers\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_");
    add_srs_wkt (p, 7,
        "Equal_Area\"],PARAMETER[\"standard_parallel_1\",42.12277");
    add_srs_wkt (p, 8,
        "4],PARAMETER[\"standard_parallel_2\",49.01518],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_center\",45.568977],PARAMETER[\"longitude");
    add_srs_wkt (p, 10,
        "_of_center\",-84.455955],PARAMETER[\"false_easting\",100");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",1000000],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3174\"]]");
    p = add_epsg_def (filter, first, last, 3175, "epsg", 3175,
        "NAD83 / Great Lakes and St Lawrence Albers");
    add_proj4text (p, 0,
        "+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568");
    add_proj4text (p, 1,
        "977 +lon_0=-83.248627 +x_0=1000000 +y_0=1000000 +datum=N");
    add_proj4text (p, 2,
        "AD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Great Lakes and St Lawrence Albers\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Albers_Conic_Equal_Area\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_1\",42.122774],PARAMETER[\"standard_parallel_2\",49.0");
    add_srs_wkt (p, 9,
        "1518],PARAMETER[\"latitude_of_center\",45.568977],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"longitude_of_center\",-83.248627],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",1000000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3175\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 3176, "epsg", 3176,
        "Indian 1960 / TM 106 NE");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +a=6377276.345 +b=6356075.413140239 +towgs84=198,88");
    add_proj4text (p, 2,
        "1,317,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1960 / TM 106 NE\",GEOGCS[\"Indian 1960\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Indian_1960\",SPHEROID[\"Everest 1830 (1937 Adj");
    add_srs_wkt (p, 2,
        "ustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "5\"]],TOWGS84[198,881,317,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6131\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4131\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",106],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"3176\"]]");
    p = add_epsg_def (filter, first, last, 3177, "epsg", 3177,
        "LGD2006 / Libya TM");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9965000000000001 +x_");
    add_proj4text (p, 1,
        "0=1000000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,");
    add_proj4text (p, 2,
        "-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM\",GEOGCS[\"LGD2006\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Libyan_Geodetic_Datum_2006\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",17],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9965],PARAMETER[\"false_easting\",1000000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3177\"]]");
    p = add_epsg_def (filter, first, last, 3178, "epsg", 3178,
        "GR96 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 18N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3178\"]]");
    p = add_epsg_def (filter, first, last, 3179, "epsg", 3179,
        "GR96 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 19N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3179\"]]");
    p = add_epsg_def (filter, first, last, 3180, "epsg", 3180,
        "GR96 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 20N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3180\"]]");
    p = add_epsg_def (filter, first, last, 3181, "epsg", 3181,
        "GR96 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 21N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3181\"]]");
    p = add_epsg_def (filter, first, last, 3182, "epsg", 3182,
        "GR96 / UTM zone 22N");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 22N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3182\"]]");
    p = add_epsg_def (filter, first, last, 3183, "epsg", 3183,
        "GR96 / UTM zone 23N");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 23N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3183\"]]");
    p = add_epsg_def (filter, first, last, 3184, "epsg", 3184,
        "GR96 / UTM zone 24N");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 24N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3184\"]]");
    p = add_epsg_def (filter, first, last, 3185, "epsg", 3185,
        "GR96 / UTM zone 25N");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 25N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3185\"]]");
    p = add_epsg_def (filter, first, last, 3186, "epsg", 3186,
        "GR96 / UTM zone 26N");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 26N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3186\"]]");
    p = add_epsg_def (filter, first, last, 3187, "epsg", 3187,
        "GR96 / UTM zone 27N");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 27N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3187\"]]");
    p = add_epsg_def (filter, first, last, 3188, "epsg", 3188,
        "GR96 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 28N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3188\"]]");
    p = add_epsg_def (filter, first, last, 3189, "epsg", 3189,
        "GR96 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GR96 / UTM zone 29N\",GEOGCS[\"GR96\",DATUM[\"G");
    add_srs_wkt (p, 1,
        "reenland_1996\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6747\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4747\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "3189\"]]");
    p = add_epsg_def (filter, first, last, 3190, "epsg", 3190,
        "LGD2006 / Libya TM zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.99995 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 5\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99995],PARAMETER[\"false_easting\",2000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"3190\"]]");
    p = add_epsg_def (filter, first, last, 3191, "epsg", 3191,
        "LGD2006 / Libya TM zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 6\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",11],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.99995],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"3191\"]]");
    p = add_epsg_def (filter, first, last, 3192, "epsg", 3192,
        "LGD2006 / Libya TM zone 7");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 7\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",13],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.99995],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"3192\"]]");
    p = add_epsg_def (filter, first, last, 3193, "epsg", 3193,
        "LGD2006 / Libya TM zone 8");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 8\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",15],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.99995],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"3193\"]]");
    p = add_epsg_def (filter, first, last, 3194, "epsg", 3194,
        "LGD2006 / Libya TM zone 9");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 9\",GEOGCS[\"LGD2006\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internat");
    add_srs_wkt (p, 2,
        "ional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",17],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.99995],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"3194\"]]");
    p = add_epsg_def (filter, first, last, 3195, "epsg", 3195,
        "LGD2006 / Libya TM zone 10");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 10\",GEOGCS[\"LGD2006\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",19],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.99995],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3195\"]]");
    p = add_epsg_def (filter, first, last, 3196, "epsg", 3196,
        "LGD2006 / Libya TM zone 11");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 11\",GEOGCS[\"LGD2006\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",21],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.99995],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3196\"]]");
    p = add_epsg_def (filter, first, last, 3197, "epsg", 3197,
        "LGD2006 / Libya TM zone 12");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 12\",GEOGCS[\"LGD2006\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",23],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.99995],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3197\"]]");
    p = add_epsg_def (filter, first, last, 3198, "epsg", 3198,
        "LGD2006 / Libya TM zone 13");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=0.99995 +x_0=200000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / Libya TM zone 13\",GEOGCS[\"LGD2006\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",25],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",0.99995],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3198\"]]");
    p = add_epsg_def (filter, first, last, 3199, "epsg", 3199,
        "LGD2006 / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=intl +towgs84=-208.406,-109.87");
    add_proj4text (p, 1,
        "8,-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / UTM zone 32N\",GEOGCS[\"LGD2006\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",9],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9996],PARAMETER[\"false_easting\",500000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"3199\"]]");
    p = add_epsg_def (filter, first, last, 3200, "epsg", 3200,
        "FD58 / Iraq zone");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.99878");
    add_proj4text (p, 1,
        "64078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +tow");
    add_proj4text (p, 2,
        "gs84=-239.1,-170.02,397.5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"FD58 / Iraq zone\",GEOGCS[\"FD58\",DATUM[\"Fina");
    add_srs_wkt (p, 1,
        "l_Datum_1958\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-239.1,-");
    add_srs_wkt (p, 3,
        "170.02,397.5,0,0,0,0],AUTHORITY[\"EPSG\",\"6132\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4132\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",32.");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",45],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9987864078],PARAMETER[\"false_easting\",15000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",1166200],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3200\"]]");
    p = add_epsg_def (filter, first, last, 3201, "epsg", 3201,
        "LGD2006 / UTM zone 33N");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=intl +towgs84=-208.406,-109.87");
    add_proj4text (p, 1,
        "8,-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / UTM zone 33N\",GEOGCS[\"LGD2006\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"3201\"]]");
    p = add_epsg_def (filter, first, last, 3202, "epsg", 3202,
        "LGD2006 / UTM zone 34N");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=intl +towgs84=-208.406,-109.87");
    add_proj4text (p, 1,
        "8,-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / UTM zone 34N\",GEOGCS[\"LGD2006\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"3202\"]]");
    p = add_epsg_def (filter, first, last, 3203, "epsg", 3203,
        "LGD2006 / UTM zone 35N");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=intl +towgs84=-208.406,-109.87");
    add_proj4text (p, 1,
        "8,-2.5764,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"LGD2006 / UTM zone 35N\",GEOGCS[\"LGD2006\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Libyan_Geodetic_Datum_2006\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[-208.406,-109.878,-2.5764,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6754\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4754\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9996],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"3203\"]]");
    p = add_epsg_def (filter, first, last, 3204, "epsg", 3204,
        "WGS 84 / SCAR IMW SP19-20");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.333333333");
    add_proj4text (p, 1,
        "33334 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SP19-20\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-60.66666666666666],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-63.33333333333334],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-66],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "204\"]]");
    p = add_epsg_def (filter, first, last, 3205, "epsg", 3205,
        "WGS 84 / SCAR IMW SP21-22");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.333333333");
    add_proj4text (p, 1,
        "33334 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SP21-22\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-60.66666666666666],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-63.33333333333334],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-54],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "205\"]]");
    p = add_epsg_def (filter, first, last, 3206, "epsg", 3206,
        "WGS 84 / SCAR IMW SP23-24");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.333333333");
    add_proj4text (p, 1,
        "33334 +lat_0=-90 +lon_0=-42 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SP23-24\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-60.66666666666666],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-63.33333333333334],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-42],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "206\"]]");
    p = add_epsg_def (filter, first, last, 3207, "epsg", 3207,
        "WGS 84 / SCAR IMW SQ01-02");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-174 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ01-02\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-174],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3207\"]]");
    p = add_epsg_def (filter, first, last, 3208, "epsg", 3208,
        "WGS 84 / SCAR IMW SQ19-20");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ19-20\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-66],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "208\"]]");
    p = add_epsg_def (filter, first, last, 3209, "epsg", 3209,
        "WGS 84 / SCAR IMW SQ21-22");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ21-22\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-54],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "209\"]]");
    p = add_epsg_def (filter, first, last, 3210, "epsg", 3210,
        "WGS 84 / SCAR IMW SQ37-38");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ37-38\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",42],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "210\"]]");
    p = add_epsg_def (filter, first, last, 3211, "epsg", 3211,
        "WGS 84 / SCAR IMW SQ39-40");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ39-40\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",54],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "211\"]]");
    p = add_epsg_def (filter, first, last, 3212, "epsg", 3212,
        "WGS 84 / SCAR IMW SQ41-42");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ41-42\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",66],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "212\"]]");
    p = add_epsg_def (filter, first, last, 3213, "epsg", 3213,
        "WGS 84 / SCAR IMW SQ43-44");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ43-44\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",78],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "213\"]]");
    p = add_epsg_def (filter, first, last, 3214, "epsg", 3214,
        "WGS 84 / SCAR IMW SQ45-46");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ45-46\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",90],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "214\"]]");
    p = add_epsg_def (filter, first, last, 3215, "epsg", 3215,
        "WGS 84 / SCAR IMW SQ47-48");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ47-48\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",102],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "215\"]]");
    p = add_epsg_def (filter, first, last, 3216, "epsg", 3216,
        "WGS 84 / SCAR IMW SQ49-50");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ49-50\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",114],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "216\"]]");
    p = add_epsg_def (filter, first, last, 3217, "epsg", 3217,
        "WGS 84 / SCAR IMW SQ51-52");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ51-52\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",126],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "217\"]]");
    p = add_epsg_def (filter, first, last, 3218, "epsg", 3218,
        "WGS 84 / SCAR IMW SQ53-54");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ53-54\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",138],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "218\"]]");
    p = add_epsg_def (filter, first, last, 3219, "epsg", 3219,
        "WGS 84 / SCAR IMW SQ55-56");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ55-56\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",150],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "219\"]]");
    p = add_epsg_def (filter, first, last, 3220, "epsg", 3220,
        "WGS 84 / SCAR IMW SQ57-58");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SQ57-58\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-64.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-67.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",162],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "220\"]]");
    p = add_epsg_def (filter, first, last, 3221, "epsg", 3221,
        "WGS 84 / SCAR IMW SR13-14");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-102 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR13-14\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-102],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3221\"]]");
    p = add_epsg_def (filter, first, last, 3222, "epsg", 3222,
        "WGS 84 / SCAR IMW SR15-16");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-90 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR15-16\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-90],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "222\"]]");
    p = add_epsg_def (filter, first, last, 3223, "epsg", 3223,
        "WGS 84 / SCAR IMW SR17-18");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-78 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR17-18\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-78],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "223\"]]");
    p = add_epsg_def (filter, first, last, 3224, "epsg", 3224,
        "WGS 84 / SCAR IMW SR19-20");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR19-20\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-66],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "224\"]]");
    p = add_epsg_def (filter, first, last, 3225, "epsg", 3225,
        "WGS 84 / SCAR IMW SR27-28");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-18 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR27-28\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-18],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "225\"]]");
    p = add_epsg_def (filter, first, last, 3226, "epsg", 3226,
        "WGS 84 / SCAR IMW SR29-30");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-6 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR29-30\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-6],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "226\"]]");
    p = add_epsg_def (filter, first, last, 3227, "epsg", 3227,
        "WGS 84 / SCAR IMW SR31-32");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=6 +x_0=0 +y_0=0 +datum=WGS84 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR31-32\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",6],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"322");
    add_srs_wkt (p, 13,
        "7\"]]");
    p = add_epsg_def (filter, first, last, 3228, "epsg", 3228,
        "WGS 84 / SCAR IMW SR33-34");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=18 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR33-34\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",18],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "228\"]]");
    p = add_epsg_def (filter, first, last, 3229, "epsg", 3229,
        "WGS 84 / SCAR IMW SR35-36");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=30 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR35-36\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",30],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "229\"]]");
    p = add_epsg_def (filter, first, last, 3230, "epsg", 3230,
        "WGS 84 / SCAR IMW SR37-38");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR37-38\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",42],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "230\"]]");
    p = add_epsg_def (filter, first, last, 3231, "epsg", 3231,
        "WGS 84 / SCAR IMW SR39-40");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR39-40\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",54],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "231\"]]");
    p = add_epsg_def (filter, first, last, 3232, "epsg", 3232,
        "WGS 84 / SCAR IMW SR41-42");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR41-42\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",66],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "232\"]]");
    p = add_epsg_def (filter, first, last, 3233, "epsg", 3233,
        "WGS 84 / SCAR IMW SR43-44");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR43-44\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",78],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "233\"]]");
    p = add_epsg_def (filter, first, last, 3234, "epsg", 3234,
        "WGS 84 / SCAR IMW SR45-46");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR45-46\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",90],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "234\"]]");
    p = add_epsg_def (filter, first, last, 3235, "epsg", 3235,
        "WGS 84 / SCAR IMW SR47-48");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR47-48\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",102],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "235\"]]");
    p = add_epsg_def (filter, first, last, 3236, "epsg", 3236,
        "WGS 84 / SCAR IMW SR49-50");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR49-50\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",114],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "236\"]]");
    p = add_epsg_def (filter, first, last, 3237, "epsg", 3237,
        "WGS 84 / SCAR IMW SR51-52");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR51-52\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",126],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "237\"]]");
    p = add_epsg_def (filter, first, last, 3238, "epsg", 3238,
        "WGS 84 / SCAR IMW SR53-54");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR53-54\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",138],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "238\"]]");
    p = add_epsg_def (filter, first, last, 3239, "epsg", 3239,
        "WGS 84 / SCAR IMW SR55-56");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR55-56\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",150],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "239\"]]");
    p = add_epsg_def (filter, first, last, 3240, "epsg", 3240,
        "WGS 84 / SCAR IMW SR57-58");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR57-58\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",162],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "240\"]]");
    p = add_epsg_def (filter, first, last, 3241, "epsg", 3241,
        "WGS 84 / SCAR IMW SR59-60");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=174 +x_0=0 +y_0=0 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SR59-60\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-68.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-71.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",174],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "241\"]]");
    p = add_epsg_def (filter, first, last, 3242, "epsg", 3242,
        "WGS 84 / SCAR IMW SS04-06");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-153 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS04-06\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-153],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3242\"]]");
    p = add_epsg_def (filter, first, last, 3243, "epsg", 3243,
        "WGS 84 / SCAR IMW SS07-09");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=-135 +x_0=0 +y_0=0 +datum=WGS84 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / SCAR IMW SS07-09\",GEOGCS[\"WGS 84\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223");
    add_srs_wkt (p, 2,
        "563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_para");
    add_srs_wkt (p, 7,
        "llel_1\",-72.66666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 8,
        "el_2\",-75.33333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",-90],PARAMETER[\"central_meridian\",-135],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "3243\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

