#ifndef __LIBSQUEEZE_COMMAND_BUILDER_H__
#define __LIBSQUEEZE_COMMAND_BUILDER_H__

#define LSQ_TYPE_COMMAND_BUILDER lsq_command_builder_get_type()

#define LSQ_COMMAND_BUILDER(obj)         ( \
		G_TYPE_CHECK_INSTANCE_CAST ((obj),    \
			LSQ_TYPE_COMMAND_BUILDER,      \
			LSQCommandBuilder))

#define LSQ_IS_COMMAND_BUILDER(obj)      ( \
		G_TYPE_CHECK_INSTANCE_TYPE ((obj),    \
			LSQ_TYPE_COMMAND_BUILDER))

#define LSQ_COMMAND_BUILDER_CLASS(klass) ( \
		G_TYPE_CHECK_CLASS_CAST ((klass),     \
			LSQ_TYPE_COMMAND_BUILDER,      \
			LSQCommandBuilderClass))

#define LSQ_IS_COMMAND_BUILDER_CLASS(klass) ( \
		G_TYPE_CHECK_CLASS_TYPE ((klass),        \
			LSQ_TYPE_COMMAND_BUILDER))

typedef struct _LSQCommandBuilder LSQCommandBuilder;

struct _LSQCommandBuilder
{
	GObject       parent;
	gchar        *id;
	gchar       **mime_types;

	LSQBuilderSettings *settings;

	LSQArchiveCommand *(*build_add)    (LSQCommandBuilder *, LSQArchive *, GSList *) G_GNUC_WARN_UNUSED_RESULT;
	LSQArchiveCommand *(*build_extract)(LSQCommandBuilder *, LSQArchive *, const gchar *, GSList *) G_GNUC_WARN_UNUSED_RESULT;
	LSQArchiveCommand *(*build_remove) (LSQCommandBuilder *, LSQArchive *, GSList *) G_GNUC_WARN_UNUSED_RESULT;
	LSQArchiveCommand *(*build_refresh)(LSQCommandBuilder *, LSQArchive *) G_GNUC_WARN_UNUSED_RESULT;
	LSQArchiveCommand *(*build_open)   (LSQCommandBuilder *, LSQArchive *, GSList *) G_GNUC_WARN_UNUSED_RESULT;
};

typedef struct _LSQCommandBuilderClass LSQCommandBuilderClass;

struct _LSQCommandBuilderClass
{
	GObjectClass parent;
};

GType                lsq_command_builder_get_type(void);
LSQBuilderSettings  *lsq_command_builder_get_settings(LSQCommandBuilder *);

#endif /* __LIBSQUEEZE_COMMAND_BUILDER_H__ */
