#include "arraytoc.h"
#include <stdio.h>

static void hexencodemap_char(void)
{
    static const uint8_t sHexChars[] = "0123456789ABCDEF";
    int i;
    uint8_t e1[256];
    uint8_t e2[256];

    for (i = 0; i < 256; ++i) {
        e1[i] = 0;
        e2[i] = 0;
    }

    for (i = 0; i < 256; ++i) {
        e1[i] = sHexChars[i >> 4];
        e2[i] = sHexChars[i & 0x0f];
    }

    char_array_to_c((char*)e1, sizeof(e1), "gsHexEncodeC1");
    char_array_to_c((char*)e2, sizeof(e2), "gsHexEncodeC2");
}

/*  exact same thing as one used on urlencode */
static void hexdecodemap(void)
{
    uint32_t i;
    uint32_t map1[256];
    uint32_t map2[256];
    for (i = 0; i < 256; ++i) {
        map1[i] = 256;
        map2[i] = 256;
    }

    /* digits */
    for (i = '0'; i <= '9'; ++i) {
        map1[i] = i - '0';
        map2[i] = map1[i] << 4;
    }

    /* upper */
    for (i = 'A'; i <= 'F'; ++i) {
        map1[i] = i - 'A' + 10;
        map2[i] = map1[i] << 4;
    }

    /* lower */
    for (i = 'a'; i <= 'f'; ++i) {
        map1[i] = i - 'a' + 10;
        map2[i] = map1[i] << 4;
    }

    uint32_array_to_c(map1, sizeof(map1) / sizeof(uint32_t), "gsHexDecodeMap");

    uint32_array_to_c(map2, sizeof(map2) / sizeof(uint32_t), "gsHexDecodeD2");
}

int main(void)
{
    hexencodemap_char();

    hexdecodemap();
    return 0;
}
