/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.CylindricalProjection;
import java.awt.geom.Point2D;

public class MercatorProjection
extends CylindricalProjection {
    public MercatorProjection() {
        this.minLatitude = MapMath.degToRad(-85.0);
        this.maxLatitude = MapMath.degToRad(85.0);
    }

    public Point2D.Double project(double lam, double phi, Point2D.Double out) {
        if (this.spherical) {
            out.x = this.scaleFactor * lam;
            out.y = this.scaleFactor * Math.log(Math.tan(0.7853981633974483 + 0.5 * phi));
        } else {
            out.x = this.scaleFactor * lam;
            out.y = -this.scaleFactor * Math.log(MapMath.tsfn(phi, Math.sin(phi), this.e));
        }
        return out;
    }

    public Point2D.Double projectInverse(double x, double y, Point2D.Double out) {
        if (this.spherical) {
            out.y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y / this.scaleFactor));
            out.x = x / this.scaleFactor;
        } else {
            out.y = MapMath.phi2(Math.exp(-y / this.scaleFactor), this.e);
            out.x = x / this.scaleFactor;
        }
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public boolean isRectilinear() {
        return true;
    }

    public int getEPSGCode() {
        return 9804;
    }

    public String toString() {
        return "Mercator";
    }
}

