/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.dracula;

import cadyts.demand.PlanChoiceModel;
import cadyts.interfaces.dracula.DraculaCalibrator;
import cadyts.interfaces.dracula.DraculaLink;
import cadyts.interfaces.dracula.DraculaPlan;
import cadyts.utilities.math.MathHelpers;
import cadyts.utilities.math.MultinomialLogit;
import cadyts.utilities.math.Vector;
import java.util.List;
import java.util.logging.Logger;

class DraculaPlanChoiceModel
implements PlanChoiceModel<DraculaPlan> {
    private final DraculaCalibrator calibrator;
    private final double stayAtHomeProb;

    DraculaPlanChoiceModel(DraculaCalibrator calibrator) {
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator is null");
        }
        this.calibrator = calibrator;
        this.stayAtHomeProb = (calibrator.getDemandScale() - 1.0) / calibrator.getDemandScale();
    }

    @Override
    public Vector getChoiceProbabilities(List<? extends DraculaPlan> plans) {
        MultinomialLogit mnl = new MultinomialLogit(plans.size() - 1, 1);
        mnl.setCoefficient(0, this.calibrator.getBetaTT_s());
        int i = 0;
        while (i < plans.size() - 1) {
            DraculaPlan plan = plans.get(i);
            if (plan.isStayAtHome()) {
                Logger.getLogger(this.getClass().getName()).warning("encountered stay-at-home plan before last position in plan list");
            }
            double tt_s = 0.0;
            for (DraculaLink link : plan.getRoute().getLinks()) {
                tt_s += this.calibrator.getTravelTimes().getTT_s(link, plan.getDepartureTime_s() + MathHelpers.round(tt_s));
            }
            mnl.setAttribute(i, 0, tt_s);
            ++i;
        }
        DraculaPlan lastPlan = plans.get(plans.size() - 1);
        if (!lastPlan.isStayAtHome()) {
            Logger.getLogger(this.getClass().getName()).warning("last plan in list is no stay-at-home plan");
        }
        Vector result = mnl.getProbs().copyEnlarged(1);
        result.mult(1.0 - this.stayAtHomeProb);
        result.set(result.size() - 1, this.stayAtHomeProb);
        return result;
    }
}

