/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.misc;

import cadyts.utilities.math.BasicStatistics;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;

public class StatisticsTracker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private double logLikelihood = 0.0;
    private boolean logLikelihoodRegistered = false;
    private double logLikelihoodPredErr = 0.0;
    private boolean logLikelihoodPredErrRegistered = false;
    private double p2pLogLikelihood = 0.0;
    private boolean p2pLogLikelihoodRegistered = false;
    private final BasicStatistics linkLambda = new BasicStatistics();
    private final BasicStatistics planLambda = new BasicStatistics();
    private long choices = 0L;

    public StatisticsTracker(String fileName) {
        this.fileName = fileName;
        this.clear();
        if (this.fileName != null) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName, false));
                writer.write("count-ll\t");
                writer.write("count-ll-pred-err\t");
                writer.write("p2p-ll\t");
                writer.write("total-ll\t");
                writer.write("link-lambda-avg\t");
                writer.write("link-lambda-stddev\t");
                writer.write("link-lambda-min\t");
                writer.write("link-lambda-max\t");
                writer.write("plan-lambda-avg\t");
                writer.write("plan-lambda-stddev\t");
                writer.write("plan-lambda-min\t");
                writer.write("plan-lambda-max\t");
                writer.write("replan-count");
                writer.newLine();
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).warning("unable to create file: " + this.fileName);
            }
        }
    }

    public void clear() {
        this.logLikelihood = 0.0;
        this.logLikelihoodRegistered = false;
        this.logLikelihoodPredErr = 0.0;
        this.logLikelihoodPredErrRegistered = false;
        this.p2pLogLikelihood = 0.0;
        this.p2pLogLikelihoodRegistered = false;
        this.linkLambda.clear();
        this.planLambda.clear();
        this.choices = 0L;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void registerSingleLinkLL(double val) {
        this.logLikelihood = val;
        this.logLikelihoodRegistered = true;
    }

    public void registerSingleLinkLLPredError(double val) {
        this.logLikelihoodPredErr = val;
        this.logLikelihoodPredErrRegistered = true;
    }

    public void registerMultiLinkLL(double val) {
        this.p2pLogLikelihood = val;
        this.p2pLogLikelihoodRegistered = true;
    }

    public void registerLinkLambda(double val) {
        this.linkLambda.add(val);
    }

    public void registerPlanLambda(double val) {
        this.planLambda.add(val);
    }

    public void registerChoice() {
        ++this.choices;
    }

    public void writeToFile() {
        if (this.fileName == null) {
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName, true));
            writer.write(this.logLikelihoodRegistered ? Double.toString(this.logLikelihood) : "--");
            writer.write("\t");
            writer.write(this.logLikelihoodPredErrRegistered ? Double.toString(this.logLikelihoodPredErr) : "--");
            writer.write("\t");
            writer.write(this.p2pLogLikelihoodRegistered ? Double.toString(this.p2pLogLikelihood) : "--");
            writer.write("\t");
            if (this.logLikelihoodRegistered || this.p2pLogLikelihoodRegistered) {
                double totalLL = 0.0;
                if (this.logLikelihoodRegistered) {
                    totalLL += this.logLikelihood;
                }
                if (this.p2pLogLikelihoodRegistered) {
                    totalLL += this.p2pLogLikelihood;
                }
                writer.write(Double.toString(totalLL));
            } else {
                writer.write("--");
            }
            writer.write("\t");
            if (this.linkLambda.size() > 0) {
                writer.write(Double.toString(this.linkLambda.getAvg()));
                writer.write("\t");
                writer.write(Double.toString(this.linkLambda.getStddev()));
                writer.write("\t");
                writer.write(Double.toString(this.linkLambda.getMin()));
                writer.write("\t");
                writer.write(Double.toString(this.linkLambda.getMax()));
            } else {
                writer.write("--\t--\t--\t--");
            }
            writer.write("\t");
            if (this.planLambda.size() > 0) {
                writer.write(Double.toString(this.planLambda.getAvg()));
                writer.write("\t");
                writer.write(Double.toString(this.planLambda.getStddev()));
                writer.write("\t");
                writer.write(Double.toString(this.planLambda.getMin()));
                writer.write("\t");
                writer.write(Double.toString(this.planLambda.getMax()));
            } else {
                writer.write("--\t--\t--\t--");
            }
            writer.write("\t");
            writer.write(Long.toString(this.choices));
            writer.newLine();
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).warning("unable to append data to file: " + this.fileName);
        }
    }
}

