/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Pair;
import helpers.RandomNumberProvider;
import interfaces.SelectableType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TypeSelection<T extends SelectableType>
extends ArrayList<Pair<T, Float>> {
    private static final long serialVersionUID = -7955432732064500764L;

    public TypeSelection() {
    }

    public TypeSelection(List<T> types) {
        for (SelectableType o : types) {
            this.add(new Pair<SelectableType, Float>(o, Float.valueOf(0.0f)));
        }
    }

    public TypeSelection(TypeSelection<T> source) {
        for (Pair pair : source) {
            this.add(new Pair<SelectableType, Float>((SelectableType)pair.getFirst(), (Float)pair.getSecond()));
        }
    }

    public void addTypesNotInSelection(TypeSelection<T> selection) {
        for (Pair pair : selection) {
            boolean found = false;
            for (Pair p : this) {
                if (!((SelectableType)pair.getFirst()).equals(p.getFirst())) continue;
                found = true;
            }
            if (found) continue;
            this.add(pair);
        }
    }

    public T getRandomType() {
        Random r = RandomNumberProvider.getRandom();
        float randomNumber = r.nextFloat();
        float lowerBound = 0.0f;
        float upperBound = 0.0f;
        for (Pair type : this) {
            upperBound = lowerBound + ((Float)type.getSecond()).floatValue();
            if (randomNumber >= lowerBound && randomNumber <= upperBound) {
                return (T)((SelectableType)type.getFirst());
            }
            lowerBound += ((Float)type.getSecond()).floatValue();
        }
        return null;
    }

    public float getTotalPercentage() {
        Float total = Float.valueOf(0.0f);
        for (Pair pair : this) {
            total = Float.valueOf(total.floatValue() + ((Float)pair.getSecond()).floatValue());
        }
        return total.floatValue() * 100.0f;
    }

    public void removeTypesWithZeroPercentage() {
        TypeSelection<T> selectionsToRemove = new TypeSelection<T>();
        for (Pair p : this) {
            if (((Float)p.getSecond()).floatValue() != 0.0f) continue;
            selectionsToRemove.add(p);
        }
        this.removeAll(selectionsToRemove);
    }

    public Float getTypePossibility(T type) {
        for (Pair t : this) {
            if (t.getFirst() != type) continue;
            return (Float)t.getSecond();
        }
        return Float.valueOf(0.0f);
    }
}

