/*
 * Decompiled with CFR 0.152.
 */
package roadnetwork;

import classes.Layer;
import enums.SelectionType;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import roadnetwork.Edge;
import roadnetwork.Junction;
import roadnetwork.RoadNetworkElement;
import shapes.Rectangle2DExt;
import trafficdefinition.TrafficDefinitionElement;

public class RoadNetwork
extends Layer<RoadNetworkElement>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<RoadNetworkElement> deletedMapElements = new ArrayList<RoadNetworkElement>();
    private List<RoadNetworkElement> selectedDeletedMapElements = new ArrayList<RoadNetworkElement>();
    private String roadNetworkEdgesXML = "";
    private String roadNetworkNodesXML = "";
    private transient boolean showDeleted = false;
    Rectangle2DExt bounds = null;

    @Override
    public void AlterSelection(Rectangle transformedRectangle, SelectionType type) {
        switch (type) {
            case New: {
                this.SelectNoneElements();
            }
            case Add: {
                List<RoadNetworkElement> newlySelectedElements;
                super.AddToSelection(transformedRectangle);
                if (!this.showDeleted || (newlySelectedElements = super.RectangleHitTest(transformedRectangle, this.deletedMapElements)).size() <= 0) break;
                this.deletedMapElements.removeAll(newlySelectedElements);
                this.selectedDeletedMapElements.addAll(newlySelectedElements);
                break;
            }
            case Remove: {
                List<RoadNetworkElement> newlyDeselectedElements;
                super.RemoveFromSelection(transformedRectangle);
                if (!this.showDeleted || (newlyDeselectedElements = super.RectangleHitTest(transformedRectangle, this.selectedDeletedMapElements)).size() <= 0) break;
                this.deletedMapElements.addAll(newlyDeselectedElements);
                this.selectedDeletedMapElements.removeAll(newlyDeselectedElements);
            }
        }
        this.NotifySelectionChanged();
    }

    @Override
    public void DeleteSelectedElements() {
        ArrayList<Edge> edgesNeeded = new ArrayList<Edge>();
        ArrayList<Junction> junctionsNeeded = new ArrayList<Junction>();
        for (RoadNetworkElement roadNetworkElement : this.selectedElements) {
            if (!(roadNetworkElement instanceof Edge) || !((Edge)roadNetworkElement).HasDependentTrafficElements()) continue;
            edgesNeeded.add((Edge)roadNetworkElement);
        }
        for (Edge edge : edgesNeeded) {
            String s = "";
            List<TrafficDefinitionElement> edgeDependencies = edge.getDependentTrafficElements();
            for (TrafficDefinitionElement tde : edgeDependencies) {
                s = String.valueOf(s) + "Name: " + tde.getName() + " Layer: " + tde.getLayer().getName() + "\n";
            }
            if (JOptionPane.showConfirmDialog(null, "You have selected to delete edge " + edge.id + "\nThe following traffic elements depend on this edge:\n" + s + "Should the edge be deleted anyway?") == 0) {
                for (TrafficDefinitionElement tde : edgeDependencies) {
                    edge.RemoveDependentTrafficElement(tde);
                    tde.getLayer().DeleteTrafficElement(tde);
                }
                continue;
            }
            this.elements.add(edge);
            this.selectedElements.remove(edge);
        }
        for (RoadNetworkElement roadNetworkElement : this.selectedElements) {
            if (!(roadNetworkElement instanceof Junction)) continue;
            for (RoadNetworkElement e : this.elements) {
                if (!(e instanceof Edge)) continue;
                Edge edge = (Edge)e;
                Junction junction = (Junction)roadNetworkElement;
                if (!edge.getFrom().equals(junction.getId()) && !edge.getTo().equals(junction.getId())) continue;
                junctionsNeeded.add(junction);
            }
        }
        for (Junction junction : junctionsNeeded) {
            this.elements.add(junction);
            this.selectedElements.remove(junction);
        }
        this.deletedMapElements.addAll(this.selectedElements);
        this.selectedElements.clear();
        this.ReCalculateBounds();
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    @Override
    public void Draw(Graphics2D g, double zoomFactor) {
        for (RoadNetworkElement e : this.elements) {
            try {
                e.Draw(g, zoomFactor, false, false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (RoadNetworkElement e : this.selectedElements) {
            e.Draw(g, zoomFactor, false, true);
        }
        if (this.showDeleted) {
            for (RoadNetworkElement e : this.deletedMapElements) {
                e.Draw(g, zoomFactor, true, false);
            }
            for (RoadNetworkElement e : this.selectedDeletedMapElements) {
                e.Draw(g, zoomFactor, true, true);
            }
        }
    }

    public Edge findClosestEdge(Point2D.Double point) {
        Edge closestEdge = null;
        double minimumDistance = 3.4028234663852886E38;
        for (Edge e : this.getEdges()) {
            double distance = e.DistanceFrom(point);
            if (!(distance < minimumDistance)) continue;
            minimumDistance = distance;
            closestEdge = e;
        }
        return closestEdge;
    }

    public Rectangle2DExt getBounds() {
        if (this.bounds == null) {
            this.ReCalculateBounds();
        }
        return this.bounds;
    }

    public List<RoadNetworkElement> getDeletedElements() {
        ArrayList<RoadNetworkElement> result = new ArrayList<RoadNetworkElement>();
        result.addAll(this.deletedMapElements);
        result.addAll(this.selectedDeletedMapElements);
        return result;
    }

    public List<Edge> getEdges() {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (RoadNetworkElement e : this.elements) {
            if (!(e instanceof Edge)) continue;
            result.add((Edge)e);
        }
        for (RoadNetworkElement e : this.selectedElements) {
            if (!(e instanceof Edge)) continue;
            result.add((Edge)e);
        }
        return result;
    }

    public List<Junction> getJunctions() {
        ArrayList<Junction> result = new ArrayList<Junction>();
        for (RoadNetworkElement e : this.elements) {
            if (!(e instanceof Junction)) continue;
            result.add((Junction)e);
        }
        for (RoadNetworkElement e : this.selectedElements) {
            if (!(e instanceof Junction)) continue;
            result.add((Junction)e);
        }
        return result;
    }

    @Override
    public List<RoadNetworkElement> getElements() {
        List<RoadNetworkElement> result = super.getElements();
        if (this.showDeleted) {
            result.addAll(this.deletedMapElements);
            result.addAll(this.selectedDeletedMapElements);
        }
        return result;
    }

    public String getRoadNetworkEdgesXML() {
        return this.roadNetworkEdgesXML;
    }

    public String getRoadNetworkNodesXML() {
        return this.roadNetworkNodesXML;
    }

    @Override
    public void NotifySelectionChanged() {
        if (!this.showDeleted) {
            super.NotifySelectionChanged();
        } else {
            ArrayList<RoadNetworkElement> allSelectedElements = new ArrayList<RoadNetworkElement>();
            allSelectedElements.addAll(this.selectedElements);
            allSelectedElements.addAll(this.selectedDeletedMapElements);
            this.NotifySelectionChanged(allSelectedElements);
        }
    }

    public void PurgeDeleted() {
        ByteArrayOutputStream edgesOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream nodesOutputStream = new ByteArrayOutputStream();
        try {
            this.RemoveDeletedFromXMLDocuments(nodesOutputStream, edgesOutputStream);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error while purging deleted elements", "Error", 0);
            e.printStackTrace();
        }
        this.roadNetworkEdgesXML = edgesOutputStream.toString();
        this.roadNetworkNodesXML = nodesOutputStream.toString();
        this.deletedMapElements.clear();
        this.selectedDeletedMapElements.clear();
        this.ReCalculateBounds();
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    /*
     * WARNING - void declaration
     */
    public void RemoveDeletedFromXMLDocuments(OutputStream nodeOutputStream, OutputStream edgeOutputStream) throws Exception {
        void var15_18;
        void var15_16;
        Document roadNetworkEdgesXMLDocument = null;
        Document roadNetworkNodesXMLDocument = null;
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        roadNetworkEdgesXMLDocument = parser.parse(new InputSource(new StringReader(this.roadNetworkEdgesXML)));
        roadNetworkNodesXMLDocument = parser.parse(new InputSource(new StringReader(this.roadNetworkNodesXML)));
        List<RoadNetworkElement> deletedElements = this.getDeletedElements();
        Hashtable<String, String> deletedEdges = new Hashtable<String, String>();
        Hashtable<String, String> deletedJunctions = new Hashtable<String, String>();
        for (RoadNetworkElement e : deletedElements) {
            if (e instanceof Edge) {
                deletedEdges.put(e.getId(), "");
                continue;
            }
            if (!(e instanceof Node)) continue;
            deletedJunctions.put(e.getId(), "");
        }
        NodeList edges = roadNetworkEdgesXMLDocument.getDocumentElement().getElementsByTagName("edge");
        NodeList junctions = roadNetworkNodesXMLDocument.getDocumentElement().getElementsByTagName("node");
        int edgesLength = edges.getLength();
        int junctionsLength = junctions.getLength();
        ArrayList<Node> edgesToDelete = new ArrayList<Node>();
        ArrayList junctionsToDelete = new ArrayList();
        boolean bl = false;
        while (var15_16 < edgesLength) {
            Node edge = edges.item((int)var15_16);
            String edgeNodeID = edge.getAttributes().getNamedItem("id").getNodeValue();
            if (deletedEdges.containsKey(edgeNodeID)) {
                edgesToDelete.add(edge);
            }
            ++var15_16;
        }
        boolean bl2 = false;
        while (var15_18 < junctionsLength) {
            Node junction = junctions.item((int)var15_18);
            String junctionNodeID = junction.getAttributes().getNamedItem("id").getNodeValue();
            if (deletedJunctions.containsKey(junctionNodeID)) {
                junctionsToDelete.add(junction);
            }
            ++var15_18;
        }
        for (Node node : edgesToDelete) {
            roadNetworkEdgesXMLDocument.getDocumentElement().removeChild(node);
        }
        for (Node node : junctionsToDelete) {
            roadNetworkNodesXMLDocument.getDocumentElement().removeChild(node);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource edgeSource = new DOMSource(roadNetworkEdgesXMLDocument);
        StreamResult edgeDestination = new StreamResult(edgeOutputStream);
        DOMSource junctionSource = new DOMSource(roadNetworkNodesXMLDocument);
        StreamResult junctionDestination = new StreamResult(nodeOutputStream);
        transformer.transform(edgeSource, edgeDestination);
        transformer.transform(junctionSource, junctionDestination);
    }

    @Override
    public void SelectAllElements() {
        super.SelectAllElements();
        if (this.showDeleted) {
            this.selectedDeletedMapElements.addAll(this.deletedMapElements);
            this.deletedMapElements.clear();
        }
        this.NotifySelectionChanged();
    }

    public List<Edge> SelectEdges(Shape s) {
        ArrayList<Edge> hitEdges = new ArrayList<Edge>();
        for (Edge e : this.getEdges()) {
            if (!e.Overlaps(s)) continue;
            hitEdges.add(e);
        }
        return hitEdges;
    }

    @Override
    public boolean SelectElement(RoadNetworkElement element) {
        if (super.SelectElement(element)) {
            return true;
        }
        this.deletedMapElements.addAll(this.selectedDeletedMapElements);
        this.selectedDeletedMapElements.clear();
        if (this.deletedMapElements.contains(element)) {
            this.selectedDeletedMapElements.add(element);
            this.deletedMapElements.remove(element);
            return true;
        }
        return false;
    }

    @Override
    public void SelectInverseElements() {
        super.SelectInverseElements();
        if (this.showDeleted) {
            ArrayList<RoadNetworkElement> temp = new ArrayList<RoadNetworkElement>();
            temp.addAll(this.deletedMapElements);
            this.deletedMapElements.clear();
            this.deletedMapElements.addAll(this.selectedDeletedMapElements);
            this.selectedDeletedMapElements.clear();
            this.selectedDeletedMapElements.addAll(temp);
        }
        this.NotifySelectionChanged();
    }

    @Override
    public void SelectNoneElements() {
        super.SelectNoneElements();
        this.deletedMapElements.addAll(this.selectedDeletedMapElements);
        this.selectedDeletedMapElements.clear();
        this.NotifySelectionChanged();
    }

    public void setRoadNetworkEdgesXML(String roadNetworkEdgesXML) {
        this.roadNetworkEdgesXML = roadNetworkEdgesXML;
    }

    public void setRoadNetworkNodesXML(String roadNetworkNodesXML) {
        this.roadNetworkNodesXML = roadNetworkNodesXML;
    }

    public void setShowDeleted(boolean showDeleted) {
        this.showDeleted = showDeleted;
        this.ReCalculateBounds();
        if (!showDeleted) {
            this.deletedMapElements.addAll(this.selectedDeletedMapElements);
            this.selectedDeletedMapElements.clear();
        }
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    public String toString() {
        return "Road Network";
    }

    public Edge findEdge(String edgeID) {
        for (Edge e : this.getEdges()) {
            if (!e.getId().equals(edgeID)) continue;
            return e;
        }
        return null;
    }

    public Junction findJunction(String junctionID) {
        for (Junction j : this.getJunctions()) {
            if (!j.getId().equals(junctionID)) continue;
            return j;
        }
        return null;
    }

    public void UndeleteSelectedMapElements() {
        ArrayList<Junction> junctionsNeeded = new ArrayList<Junction>();
        for (RoadNetworkElement r : this.selectedDeletedMapElements) {
            if (!(r instanceof Edge)) continue;
            Edge edge = (Edge)r;
            for (RoadNetworkElement j : this.deletedMapElements) {
                if (!(j instanceof Junction)) continue;
                Junction junction = (Junction)j;
                if (!edge.getFrom().equals(junction.getId()) && !edge.getTo().equals(junction.getId())) continue;
                junctionsNeeded.add(junction);
            }
        }
        for (Junction j : junctionsNeeded) {
            this.selectedElements.add(j);
            this.deletedMapElements.remove(j);
        }
        this.selectedElements.addAll(this.selectedDeletedMapElements);
        this.selectedDeletedMapElements.clear();
        this.ReCalculateBounds();
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    private void ReCalculateBounds() {
        List<RoadNetworkElement> allElements = this.getElements();
        this.bounds = allElements.get(0).getBounds();
        for (RoadNetworkElement e : allElements) {
            this.bounds.add(e.getBounds());
        }
        double maxdim = Math.max(this.bounds.width, this.bounds.height);
        double widthenlargement = maxdim * 0.1;
        this.bounds.x -= maxdim * 0.05;
        this.bounds.y -= maxdim * 0.05;
        this.bounds.width += widthenlargement;
        this.bounds.height += widthenlargement;
    }
}

