/*
 * Decompiled with CFR 0.152.
 */
package ui.controls;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import roadnetwork.RoadNetwork;
import trafficdefinition.ActivityBasedTrafficDefinitionLayer;
import trafficdefinition.RandomTrafficDefinitionLayer;
import trafficdefinition.UserDefinedTrafficDefinitionLayer;

public class ProjectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    ImageIcon mapIcon = new ImageIcon(this.getClass().getResource("/resources/icons/map.png"));
    ImageIcon activityBasedTrafficLayerIcon = new ImageIcon(this.getClass().getResource("/resources/icons/layeractivity.png"));
    ImageIcon randomTrafficLayerIcon = new ImageIcon(this.getClass().getResource("/resources/icons/layerrandom.png"));
    ImageIcon userDefinedTrafficLayerIcon = new ImageIcon(this.getClass().getResource("/resources/icons/layeruser.png"));
    ImageIcon trafficLayersIcon = new ImageIcon(this.getClass().getResource("/resources/icons/layers.png"));

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String s;
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object nodeInfo = node.getUserObject();
        if (nodeInfo instanceof ActivityBasedTrafficDefinitionLayer) {
            this.setIcon(this.activityBasedTrafficLayerIcon);
        } else if (nodeInfo instanceof RandomTrafficDefinitionLayer) {
            this.setIcon(this.randomTrafficLayerIcon);
        } else if (nodeInfo instanceof UserDefinedTrafficDefinitionLayer) {
            this.setIcon(this.userDefinedTrafficLayerIcon);
        } else if (nodeInfo instanceof RoadNetwork) {
            this.setIcon(this.mapIcon);
        } else if (nodeInfo instanceof String && (s = (String)nodeInfo).equals("Traffic Layers")) {
            this.setIcon(this.trafficLayersIcon);
        }
        return this;
    }
}

