/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Foobar is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Foobar is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/main.h>
#include "db.hh"
#include "window1.hh"
#include "gstreamer.hh"


TWindow1 *Window1;
Tdb *db;  
tGst *gst;


int main(int argc, char **argv)
{

#if defined(ENABLE_NLS)
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif 
	Gtk::Main application(&argc, &argv);

	gst = new class tGst;
	gst->init(argc, argv);

   
	db = new class Tdb();  
	if (db->open()) {
		Window1 = new class TWindow1();
		Window1->init();

		application.run(*Window1);
		db->close();
		delete db;
		delete Window1;
	}

	gst->close();
	return 0;
}
