
import swiginac
from swiginac import *

def tr(A):
    return sum(A[i,i] for i in range(3))

def inner(A, B):
    return sum(A[i,j]*B[i,j] for i in range(3) for j in range(3))

def diff(f, v):
    if isinstance(v, matrix):
        assert not isinstance(f, matrix)
        return matrix(3, 3, [swiginac.diff(f, v[i,j]) for i in range(3) for j in range(3)])
    return swiginac.diff(f, v)

def subs(f, s, v):
    assert isinstance(s, matrix)
    assert isinstance(v, matrix)
    repmap = exmap()
    for i in range(3):
        for j in range(3):
            repmap[s[i,j]] = v[i,j]
    return f.subs(repmap)

# --- Derivation of manufactured analytical solution:

# Some useful symbols
x = matrix(3,1, [symbol("x[%d]" % i) for i in range(3)])

K   = symbol("K")
bff = symbol("bff")
bfx = symbol("bfx")
bxx = symbol("bxx")
C_compr = symbol("C_compr")

# Picking an arbitrary divergence free solution
a = symbol("a")
u = matrix(3,1, [a*(sin(x[1]) - x[1]),
                 a*(sin(x[2]) - x[2]),
                 a*(sin(x[0]) - x[0])])

div_u = sum(diff(u[i], x[i]) for i in range(3))
if not div_u.expand().evalf() == 0:
    print "WARNING: div(u) =", div_u

# Want to compute g!

# Compute value of F 
I = matrix(3, 3, [1,0,0, 0,1,0, 0,0,1])
DuT = matrix(3, 3, [diff(u[i], x[j]) for i in range(3) for j in range(3)])
Fvalue = I + DuT

# Compute psi(F)
F = symbolic_matrix(3, 3, "F")
FT = transpose(F)
J = determinant(F)
C = FT*F
E = (C - I) / 2
Q = bff *  E[0,0]**2 + \
    bxx * (E[1,1]**2 + E[2,2]**2 + E[1,2]**2 + E[2,1]**2) + \
    bfx * (E[0,1]**2 + E[0,2]**2 + E[1,0]**2 + E[2,0]**2)
psi = (K/2)*(exp(Q) - 1) + C_compr * (J*log(J) - J + 1)

# First Piola-Kirchoff stress tensor
P = diff(psi, F)

# Substitute value of F into P
P = subs(P, F, Fvalue)

# Compute g using strong form of equation # FIXME: Signs!
#g = u - div P
divP = matrix(3, 1, [sum(diff(P[i,j], x[i]) for i in range(3)) for j in range(3)])
g = u - divP

# Print solutions
print
print "u:"
print "        values[0] = %s;" % u[0].printc()
print "        values[1] = %s;" % u[1].printc()
print "        values[2] = %s;" % u[2].printc()
print
print "g:"
print "        values[0] = %s;" % g[0].printc()
print "        values[1] = %s;" % g[1].printc()
print "        values[2] = %s;" % g[2].printc()
print

