#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
This module contains a class for representing quadrature rules.
"""

# Copyright (C) 2007 Martin Sandve Alnes and Simula Resarch Laboratory
#
# This file is part of SyFi.
#
# SyFi is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# SyFi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SyFi. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  November 29th 2007
# Last changed: November 29th 2007

class QuadRule:
    """This class represents a specific quadrature rule over a polygon."""
    def __init__(self, polygon, nsd, order, points, weights, comment):
        assert len(points) == len(weights)
        self.polygon    = polygon
        self.nsd        = nsd
        self.num_points = len(points)
        self.points     = points
        self.weights    = weights
        self.comment    = comment
        self.order      = order
    
    def __str__(self):
        s  = "Quadrature rule:\n"
        s += "  comment: %s\n" % self.comment
        s += "  polygon     = %s\n" % self.polygon
        s += "  nsd         = %d\n" % self.nsd
        s += "  num_points  = %d\n" % self.num_points
        s += "  points      = %s\n" % self.points
        s += "  weights     = %s\n" % self.weights
        s += "  order       = %d\n" % self.order
        return s


if __name__ == '__main__':
    print "No test here."

