#!/usr/bin/env python
from dolfin import Mesh, MeshEditor, assemble

cell2dim = { "interval": 1, "triangle": 2, "tetrahedron": 3, "quadrilateral": 2, "hexahedron": 3 }

cell2volume = { "interval": 1.0, "triangle": 0.5, "tetrahedron": 1.0/6.0, "quadrilateral": 1.0, "hexahedron": 1.0 }

def UnitCell(celltype):
    tdim = cell2dim[celltype]
    gdim = tdim
    mesh = Mesh()
    editor = MeshEditor()
    editor.open(mesh, celltype, tdim, gdim)
    if celltype == "interval":
        vertices = [(0.0,),
                    (1.0,)]
    if celltype == "triangle":
        vertices = [(0.0, 0.0),
                    (1.0, 0.0),
                    (0.0, 1.0)]
    if celltype == "tetrahedron":
        vertices = [(0.0, 0.0, 0.0),
                    (1.0, 0.0, 0.0),
                    (0.0, 1.0, 0.0),
                    (0.0, 0.0, 1.0)]
    if celltype == "quadrilateral":
        vertices = [(0.0, 0.0),
                    (1.0, 0.0),
                    (1.0, 1.0),
                    (0.0, 1.0)]
    if celltype == "hexahedron":
        vertices = [(0.0, 0.0, 0.0),
                    (1.0, 0.0, 0.0),
                    (1.0, 1.0, 0.0),
                    (0.0, 1.0, 0.0),
                    (0.0, 0.0, 1.0),
                    (1.0, 0.0, 1.0),
                    (1.0, 1.0, 1.0),
                    (0.0, 1.0, 1.0)]
    editor.initVertices(len(vertices))
    editor.initCells(1)
    for i, p in enumerate(vertices):
        editor.addVertex(i, *p)
    editor.addCell(0, *range(len(vertices)))
    editor.close()
    return mesh


def assemble_on_cell(form, celltype, coeffs):
    "Assemble UFC form on a unit cell mesh and return the result as a float or numpy array."
    mesh = UnitCell(celltype)
    A = assemble(form, mesh, coeffs)
    if isinstance(A, float):
        return A
    return A.array()

