
from swiginac import *
from SyFi import *
from sfc.integral_tools import integral, geometry_mapping 
from sfc.symbolic_utils import symbol, symbols

setDigits(5)

print ""
print "--------- 1D -----------------"
print ""
initSyFi(1)
x = symbol("x")
t = ReferenceLine()

f = x*x*x  

print "symbolic  integral of ",f," on reference line  ", integral(t,f, True)
print "numerical integral of ",f," on reference line  ", integral(t,f, False,3)

print ""
print "--------- 2D -----------------"
print ""
initSyFi(2)
x, y = symbols("xy")
t = ReferenceTriangle()

print "symbolic  integral of ",f," on reference triangle  ", integral(t,f, True)
print "numerical integral of ",f," on reference triangle  ", integral(t,f, False,3)

print ""
print "--------- 3D -----------------"
print ""
initSyFi(3)
x, y, z = symbols("xyz")
f = 3.7*x -  2.8*y + 7.4*z + 3.14
t = ReferenceTetrahedron()

print "symbolic  integral of ",f," on reference tetrahedron  ", integral(t,f, True)
print "numerical integral of ",f," on reference tetrahedron  ", integral(t,f, False,3)




print ""
print "--------- 2D -----------------"
print ""
f = 3.7*x -  2.8*y + 3.14
initSyFi(2)
x, y = symbols("xy")
t = Triangle([1.3, 1.3], [2.4,2.1], [1.4, 2.8])
G, x0 = geometry_mapping(t)
detG = G.determinant()
fe = Lagrange(t)
integrand = fe.N(0)*f 

print ""
print "integral of ",f," on global triangle         ", integral(t, integrand, True, 3)
print ""

xi0 = symbol("xi0"); xi1 = symbol("xi1")
tr = ReferenceTriangle()
fe = Lagrange(tr)
N0 = fe.N(0).subs( [x == xi0, y == xi1] ) 
integrand = N0*f 
print "symbolic integral of ",f," on global triangle", integral(t, integrand, True, 1)
print "numeric  integral of ",f," on global triangle", integral(t, integrand, False, 2)


print ""
print "--------- 3D -----------------"
print ""
f = 3.7*x -  2.8*y + 7.4*z + 3.14
initSyFi(3)
x, y, z = symbols("xyz")
t = Tetrahedron([1.3, 1.3, 1.3], [2.4, 1.1, 1.2 ], [1.4, 2.8, 1.3], [1.5, 1.3, 3.0])
G, x0 = geometry_mapping(t)
detG = G.determinant()
fe = Lagrange(t)
integrand = fe.N(0)*f 

print "integral of ",f," on global tetrahedron         ", integral(t, integrand, True, 3)

xi0 = symbol("xi0"); xi1 = symbol("xi1"); xi2 = symbol("xi2")
tr = ReferenceTetrahedron()
fe = Lagrange(tr)
N0 = fe.N(0).subs( [x == xi0, y == xi1, z == xi2] ) 
print "symbolic integral of ",f," on global tetrahedron", integral(t, integrand, True, 1)
print "numeric  integral of ",f," on global tetrahedron", integral(t, integrand, False, 3)


