/* 
 * vt102_charset.c:
 *
 * Copyright (c) 2008 James McKenzie <sympathy@madingley.org>,
 * All rights reserved.
 *
 */

static char rcsid[] =
  "$Id: vt102_charset.c,v 1.5 2008/03/07 12:37:04 james Exp $";

/* 
 * $Log: vt102_charset.c,v $
 * Revision 1.5  2008/03/07 12:37:04  james
 * *** empty log message ***
 *
 * Revision 1.4  2008/02/27 00:54:16  james
 * *** empty log message ***
 *
 * Revision 1.3  2008/02/27 00:27:22  james
 * *** empty log message ***
 *
 * Revision 1.2  2008/02/26 23:56:12  james
 * *** empty log message ***
 *
 * Revision 1.1  2008/02/26 23:23:17  james
 * *** empty log message ***
 *
 */

#include "project.h"

uint32_t vt102_charset_c0[VT102_CHARSET_SIZE] = {
  [0x00] = 0x2400,
  [0x01] = 0x2401,
  [0x02] = 0x2402,
  [0x03] = 0x2403,
  [0x04] = 0x2404,
  [0x05] = 0x2405,
  [0x06] = 0x2406,
  [0x07] = 0x2407,
  [0x08] = 0x2408,
  [0x09] = 0x2409,
  [0x0a] = 0x240a,
  [0x0b] = 0x240b,
  [0x0c] = 0x240c,
  [0x0d] = 0x240d,
  [0x0e] = 0x240e,
  [0x0f] = 0x240f,
  [0x10] = 0x2410,
  [0x11] = 0x2411,
  [0x12] = 0x2412,
  [0x13] = 0x2413,
  [0x14] = 0x2414,
  [0x15] = 0x2415,
  [0x16] = 0x2416,
  [0x17] = 0x2417,
  [0x18] = 0x2418,
  [0x19] = 0x2419,
  [0x1a] = 0x241a,
  [0x1b] = 0x241b,
  [0x1c] = 0x241c,
  [0x1d] = 0x241d,
  [0x1e] = 0x241e,
  [0x1f] = 0x241f,
  [0x7f] = 0x2421,
};

uint32_t vt102_charset_us[VT102_CHARSET_SIZE] = { 0 };

uint32_t vt102_charset_uk[VT102_CHARSET_SIZE] = {
  [0x23] = 0x00a3,
};

uint32_t vt102_charset_vt52[VT102_CHARSET_SIZE] = {
  [0x5f] = 0x25ae,
  [0x60] = 0x25ae,
  [0x61] = 0x25ae,
  [0x62] = 0x215f,
  [0x63] = '3',                 // 3/
  [0x64] = '5',                 // 5/
  [0x65] = '7',                 // 7/
  [0x66] = 0x00b0,
  [0x67] = 0x00b1,
  [0x68] = 0x2192,
  [0x69] = 0x2026,
  [0x6a] = 0x00f7,
  [0x6b] = 0x2193,
  [0x6c] = 0x23ba,              // bar scan 0
  [0x6d] = 0x23ba,
  [0x6e] = 0x23bb,              // bar scan 2
  [0x6f] = 0x23bb,
  [0x70] = 0x2500,              // bar scan 4
  [0x71] = 0x23bc,
  [0x72] = 0x23bd,              // bar scan 6
  [0x73] = 0x23bd,
  [0x74] = 0x2080,
  [0x75] = 0x2081,
  [0x76] = 0x2082,
  [0x77] = 0x2083,
  [0x78] = 0x2084,
  [0x79] = 0x2085,
  [0x7a] = 0x2086,
  [0x7b] = 0x2087,
  [0x7c] = 0x2088,
  [0x7d] = 0x2089,
  [0x7e] = 0x00b6
};


uint32_t vt102_charset_gl[VT102_CHARSET_SIZE] = {
  [0x5f] = 0x25ae,
  [0x60] = 0x25c6,
  [0x61] = 0x2592,
  [0x62] = 0x2409,
  [0x63] = 0x240c,
  [0x64] = 0x240d,
  [0x65] = 0x240a,
  [0x66] = 0x00b0,
  [0x67] = 0x00b1,
  [0x68] = 0x2424,
  [0x69] = 0x240b,
  [0x6a] = 0x2518,
  [0x6b] = 0x2510,
  [0x6c] = 0x250c,
  [0x6d] = 0x2514,
  [0x6e] = 0x253c,
  [0x6f] = 0x23ba,
  [0x70] = 0x23bb,
  [0x71] = 0x2500,
  [0x72] = 0x23bc,
  [0x73] = 0x23bd,
  [0x74] = 0x251c,
  [0x75] = 0x2524,
  [0x76] = 0x2534,
  [0x77] = 0x252c,
  [0x78] = 0x2502,
  [0x79] = 0x2264,
  [0x7a] = 0x2265,
  [0x7b] = 0x03c0,
  [0x7c] = 0x2260,
  [0x7d] = 0x00a3,
  [0x7e] = 0x00b7
};


uint32_t *charset_from_csid[] = {
  [VT102_CSID_US] = vt102_charset_us,
  [VT102_CSID_UK] = vt102_charset_uk,
  [VT102_CSID_GL] = vt102_charset_gl,
  [VT102_CSID_VT52] = vt102_charset_vt52
};
