C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=CMPTEL,SSI=0
                        SUBROUTINE CMPTEL
C                       *****************
C
C     --------------------------------------------------
     *(NODES,NREFS,ITAB,NPOINS,NDIELE,NDMATS,NBFACE,NELEMS,
     * NELESS,NELEUS,NELEPR,NELERC,NELERA,NBFLUS,NRAJOU)
C     --------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             COMPTE DES ELEMENTS PORTANT LES DIVERSES CONDITIONS      *
C             POSSIBLES                                                *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NODES    ! TE ! D  ! CONNECTIVITE                                 !
C !  NREFS    ! TE ! D  ! NUMEROS DE REFERENCE DES NOEUDS              !
C !  NPOINS   !  E ! D  ! NBRE DE NOEUDS SOLIDES                       !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELEMENTS                       !
C !  NDMATS   !  E ! D  ! NBRE DE NOEUDS DES ELEMENTS                  !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACE DES ELTS VOL SOLIDES          !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NELESS   !  E ! R  ! NOMBRE D'ELTS DU MAILLAGE SURF SOLIDE        !
C !  NELEUS   !  E ! R  ! NBRE D'ELTS DU MAILLAGE SURF SOLIDE AVEC FLUX!
C !  NELEPR   !  E ! R  ! NBRE D'ELTS DU MAIL VOL SOLIDE PERIODIQUE    !
C !  NELERA   !  E ! R  ! NBRE D'ELTS DU MAIL SURF SOLIDE RAYT         !
C !  NBFLUS   !  E ! R  ! NOMBRE DE NOEUDS SOLIDES AVEC CL DE TYPE FLUX!
C !  NRAJOU   !  E ! R  ! NBRE DE NOEUDS RAJOUTES A LA TABLE DES FLUX  !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "xrefer.h"
#include "nlofes.h"
#include "mobil.h"
#include "nlofct.h"
#include "divct.h"
C
C***********************************************************************
C 
      INTEGER NDX
      PARAMETER (NDX=10)
C
C.. Variables externes
      INTEGER NPOINS,NDIELE,NDMATS,NBFACE,NELEMS
      INTEGER NODES(NELEMS,NDMATS),NREFS(NPOINS),ITAB(NPOINS)
      INTEGER NELESS,NELEUS,NELEPR,NELERC,NBFLUS,NRAJOU,NELERA
C
C.. Variables internes
      LOGICAL LFFLU(NDX),LFCOU(NDX),LPDIR(NDX),LFRES(NDX),LFRAY(NDX)
      LOGICAL LPERIO
      INTEGER N,N1,N2,NUMREF
      INTEGER NO2(2,3),NO3(3,4)
C
C***********************************************************************
C
      DATA NO2 /1,2,    2,3,    3,1/
      DATA NO3 /1,3,2,  1,2,4,  1,4,3,  2,3,4/
C
C     0- INITIALISATIONS
C     ==================
C
      NELESS = 0
      NELEUS = 0
      NELEPR = 0
      NELERC = 0
      NELERA = 0
      NRAJOU = 0
C
      DO 10 N=1,NPOINS
       ITAB(N) = 0
   10 CONTINUE
C
C     1- BOUCLE SUR LES ELEMENTS
C     ==========================
      DO 550 N=1,NELEMS
C
       CALL EVATYP (N,NDIELE,NODES,NELEMS,NDMATS,NREFS,NPOINS,
     &              LFFLU,LFCOU,LFRES,LFRAY,NBFACE,LPDIR)
C
        DO 551 N1=1,NBFACE
          IF (LFFLU(N1)) NELEUS = NELEUS + 1
          IF (LFCOU(N1)) NELESS = NELESS + 1
          IF (LFRES(N1)) NELERC = NELERC + 1
          IF (LFRAY(N1)) THEN
              NELERA = NELERA + 1
              IF (NDIELE.EQ.2) THEN
                ITAB(NODES(N,NO2(1,N1))) = -1
                ITAB(NODES(N,NO2(2,N1))) = -1
              ELSE
                ITAB(NODES(N,NO3(1,N1))) = -1
                ITAB(NODES(N,NO3(2,N1))) = -1
                ITAB(NODES(N,NO3(3,N1))) = -1
              ENDIF        
          ENDIF
  551   CONTINUE
C
        DO 552 N1=1,NDMATS
          IF (LPDIR(N1)) THEN
             NBFLUS = NBFLUS + 1
             NRAJOU = NRAJOU + 1
          ENDIF
  552   CONTINUE
C
        LPERIO = .FALSE.
        DO 553 N1=1,NDMATS
          NUMREF = NREFS(NODES(N,N1))
          IF (NUMREF.NE.0) THEN
            DO 554 N2=1,NRFMAX
              IF (IREFPR(N2).NE.0 .AND. NUMREF.EQ.N2) LPERIO = .TRUE.
  554       CONTINUE
          ENDIF
  553   CONTINUE
        IF (LPERIO) NELEPR = NELEPR + 1
C
C 
  550 CONTINUE
C
C
C     2- COMPTE DES NOEUDS SOMMETS AVEC RAYONNEMENT
C     ==========================================
      NPRAP1 = 0
      DO 600 N=1,NPOINS
        IF (ITAB(N).NE.0) NPRAP1 = NPRAP1+1
  600 CONTINUE
C
      END
