C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=VERIFA,SSI=0
                        SUBROUTINE VERIFA
C                       *****************
C
C     ------------------------------
     * (NDIELE,NELEMS,NBFACE,NREFAC)
C     ------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             VERIFICATION QUE LE TABLEAU DES REFERENCES DE FACES      *
C             A BIEN ETE REMPLI                                        *
C             Les references sur les faces sont necessaires lorsque    *
C             l'on veut imposer les  conditions aux limites sur        *
C             les faces                                                *
C                                                                      *
C        Sous programme utilisateur                                    *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEMES                       !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELEMENTS(2=triangles,3=tetraed)!
C !  NREFAC   ! TE ! R  ! REFERENCES DES FACES SOLIDES (volumiques)    !
C !  NODES    ! TE ! D  ! CONNECTIVITE                                 !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS PAR ELEMENTS                !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELEMENTS                            !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS SOLIDES               !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C 
C.. Variables externes
      INTEGER NDIELE,NELEMS,NBFACE,NREFAC(NELEMS,NBFACE)
C
C.. Variables internes
      INTEGER I
      LOGICAL LOK
C
C***********************************************************************
C
C
C     1- TEST
C     =======
C
      LOK = .FALSE.
C
      DO 200 I=1,NELEMS*NBFACE
        IF (NREFAC(I,1) .NE. 0) LOK = .TRUE.
  200 CONTINUE
C
C
C     2- IMPRESSION
C     =============
C
      IF (.NOT. LOK) WRITE(NFECRA,2000)
C
C
C--------
C FORMATS
C--------
 2000 FORMAT(/,' $$ ATTENTION VERIFA : VOUS AVEZ DEMANDE ',
     &         'L''IMPOSISTION DES CONDITIONS AUX LIMITES PAR FACE',/,
     &         '                       ET TOUTES LES REFERENCES SUR ',
     &         'LES FACES SONT NULLES !!!',/)
C
      END
